/*
 * Decompiled with CFR 0.152.
 */
package com.eaio.uuid;

import com.eaio.uuid.Hex;
import com.eaio.uuid.MACAddressParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class MACAddress {
    private static String macAddress;

    /*
     * Loose catch block
     */
    static {
        block49: {
            macAddress = null;
            if (macAddress == null) {
                Process p;
                block50: {
                    BufferedReader in;
                    block48: {
                        p = null;
                        in = null;
                        try {
                            String osname = System.getProperty("os.name", "");
                            if (osname.startsWith("Windows")) {
                                p = Runtime.getRuntime().exec(new String[]{"ipconfig", "/all"}, null);
                            } else if (osname.startsWith("Solaris") || osname.startsWith("SunOS")) {
                                String hostName = MACAddress.getFirstLineOfCommand(new String[]{"uname", "-n"});
                                if (hostName != null) {
                                    p = Runtime.getRuntime().exec(new String[]{"/usr/sbin/arp", hostName}, null);
                                }
                            } else if (new File("/usr/sbin/lanscan").exists()) {
                                p = Runtime.getRuntime().exec(new String[]{"/usr/sbin/lanscan"}, null);
                            } else if (new File("/sbin/ifconfig").exists()) {
                                p = Runtime.getRuntime().exec(new String[]{"/sbin/ifconfig", "-a"}, null);
                            }
                            if (p == null) break block48;
                            in = new BufferedReader(new InputStreamReader(p.getInputStream()), 128);
                            String l = null;
                            while ((l = in.readLine()) != null) {
                                macAddress = MACAddressParser.parse(l);
                                if (macAddress == null || Hex.parseShort(macAddress) == 255) {
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (SecurityException securityException) {
                            if (p == null) break block49;
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            try {
                                p.getErrorStream().close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            try {
                                p.getOutputStream().close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            p.destroy();
                            break block49;
                        }
                        catch (IOException iOException) {
                            if (p == null) break block49;
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException iOException2) {
                                    // empty catch block
                                }
                            }
                            try {
                                p.getErrorStream().close();
                            }
                            catch (IOException iOException3) {
                                // empty catch block
                            }
                            try {
                                p.getOutputStream().close();
                            }
                            catch (IOException iOException4) {
                                // empty catch block
                            }
                            p.destroy();
                            break block49;
                            catch (Throwable throwable) {
                                if (p != null) {
                                    if (in != null) {
                                        try {
                                            in.close();
                                        }
                                        catch (IOException iOException5) {
                                            // empty catch block
                                        }
                                    }
                                    try {
                                        p.getErrorStream().close();
                                    }
                                    catch (IOException iOException6) {
                                        // empty catch block
                                    }
                                    try {
                                        p.getOutputStream().close();
                                    }
                                    catch (IOException iOException7) {
                                        // empty catch block
                                    }
                                    p.destroy();
                                }
                                throw throwable;
                            }
                        }
                    }
                    if (p == null) break block49;
                    if (in == null) break block50;
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                try {
                    p.getErrorStream().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    p.getOutputStream().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                p.destroy();
            }
        }
        if (macAddress == null) {
            try {
                macAddress = String.valueOf(InetAddress.getLocalHost().getHostAddress()) + "#" + InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                macAddress = null;
            }
        }
    }

    public static String getMACAddress() {
        return macAddress;
    }

    static String getFirstLineOfCommand(String[] commands) throws IOException {
        Process p = null;
        BufferedReader reader = null;
        try {
            p = Runtime.getRuntime().exec(commands);
            reader = new BufferedReader(new InputStreamReader(p.getInputStream()), 128);
            String string = reader.readLine();
            return string;
        }
        finally {
            if (p != null) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                try {
                    p.getErrorStream().close();
                }
                catch (IOException iOException) {}
                try {
                    p.getOutputStream().close();
                }
                catch (IOException iOException) {}
                p.destroy();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        System.err.println(MACAddress.getMACAddress());
    }
}

